//LLAMA2-13B DATASET v1.0 Category: Client Server Application ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    // Client side
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    struct sockaddr_in server_addr;
    char buffer[1024];

    printf("Surprise! I'm the client!\n");

    // Connect to the server
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);
    connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr));

    // Send a message to the server
    printf("Sending message...\n");
    send(sock, "Hello, server! 😱\n", strlen("Hello, server! 😱"), 0);

    // Receive a message from the server
    printf("Receiving message...\n");
    recv(sock, buffer, 1024, 0);
    printf("Received message: %s\n", buffer);

    // Close the connection
    printf("Closing connection...\n");
    close(sock);

    // Server side
    sock = socket(AF_INET, SOCK_STREAM, 0);
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    // Bind the server to the port
    printf("Binding to port %d...\n", PORT);
    bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr));

    // Listen for incoming connections
    printf("Listening for incoming connections...\n");
    listen(sock, 3);

    // Accept an incoming connection
    printf("Accepting incoming connection...\n");
    int client_sock = accept(sock, NULL, NULL);

    // Send a message to the client
    printf("Sending message to client...\n");
    send(client_sock, "Hello, client! 😱\n", strlen("Hello, client! 😱"), 0);

    // Receive a message from the client
    printf("Receiving message from client...\n");
    recv(client_sock, buffer, 1024, 0);
    printf("Received message from client: %s\n", buffer);

    // Close the connection
    printf("Closing connection...\n");
    close(client_sock);

    return 0;
}