//Falcon-180B DATASET v1.0 Category: GPS Navigation Simulation ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAP_WIDTH 20
#define MAP_HEIGHT 10
#define MAP_SIZE (MAP_WIDTH * MAP_HEIGHT)

typedef struct {
    int x;
    int y;
} Location;

Location current_location;
Location destination;

void init_map() {
    int i, j;
    for (i = 0; i < MAP_HEIGHT; i++) {
        for (j = 0; j < MAP_WIDTH; j++) {
            if ((i + j) % 2 == 0) {
                printf("X");
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

void move(int dx, int dy) {
    current_location.x += dx;
    current_location.y += dy;
}

void print_location(Location loc) {
    printf("Current location: (%d, %d)\n", loc.x, loc.y);
}

void set_destination(int x, int y) {
    destination.x = x;
    destination.y = y;
}

int distance(Location a, Location b) {
    int dx = abs(a.x - b.x);
    int dy = abs(a.y - b.y);
    return dx + dy;
}

int main() {
    srand(time(0));
    init_map();
    current_location.x = rand() % MAP_WIDTH;
    current_location.y = rand() % MAP_HEIGHT;
    set_destination(rand() % MAP_WIDTH, rand() % MAP_HEIGHT);

    while (distance(current_location, destination) > 0) {
        int dx = destination.x - current_location.x;
        int dy = destination.y - current_location.y;

        if (dx > 0) {
            move(1, 0);
        } else if (dx < 0) {
            move(-1, 0);
        }

        if (dy > 0) {
            move(0, 1);
        } else if (dy < 0) {
            move(0, -1);
        }

        print_location(current_location);
    }

    printf("Arrived at destination!\n");
    return 0;
}