//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MSG_KEY 12345

struct msgbuf {
  long mtype;
  char mtext[256];
};

int main() {
  int msgid;
  struct msgbuf msg;

  // Create a message queue.
  msgid = msgget(MSG_KEY, IPC_CREAT | 0666);
  if (msgid == -1) {
    perror("msgget");
    exit(EXIT_FAILURE);
  }

  // Create a child process.
  int pid = fork();
  if (pid == -1) {
    perror("fork");
    exit(EXIT_FAILURE);
  }

  // Send a message from the parent process to the child process.
  if (pid > 0) {
    msg.mtype = 1;
    snprintf(msg.mtext, sizeof(msg.mtext), "My sweetest love, I adore you!");
    if (msgsnd(msgid, &msg, sizeof(msg.mtext), 0) == -1) {
      perror("msgsnd");
      exit(EXIT_FAILURE);
    }

    // Wait for the child process to finish.
    wait(NULL);
  }
  // Receive a message from the child process.
  else {
    if (msgrcv(msgid, &msg, sizeof(msg.mtext), 1, 0) == -1) {
      perror("msgrcv");
      exit(EXIT_FAILURE);
    }

    // Print the message.
    printf("%s\n", msg.mtext);
  }

  // Destroy the message queue.
  msgctl(msgid, IPC_RMID, NULL);

  return EXIT_SUCCESS;
}