//Gemma-7B DATASET v1.0 Category: Game of Life ; Style: systematic
#include <stdio.h>
#include <stdlib.h>

#define MAX_CELLS 10

int main()
{
    int cells[MAX_CELLS] = {0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
    int i, j, k, l, generation = 0;
    char board[MAX_CELLS][MAX_CELLS] = {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    // Initialize the game board
    for (i = 0; i < MAX_CELLS; i++)
    {
        for (j = 0; j < MAX_CELLS; j++)
        {
            board[i][j] = ' ';
        }
    }

    // Place the initial cells on the board
    for (k = 0; k < MAX_CELLS; k++)
    {
        cells[k] = cells[k] ? 1 : 0;
    }

    // Game loop
    while (cells[0] || cells[MAX_CELLS - 1])
    {
        // Calculate the number of neighbors for each cell
        for (i = 0; i < MAX_CELLS; i++)
        {
            l = 0;
            for (j = -1; j <= 1; j++)
            {
                if (cells[i - 1] && cells[i - 1] > l) l++;
                if (cells[i + 1] && cells[i + 1] > l) l++;
                if (cells[i] && cells[i] > l) l++;
            }
            cells[i] = l == 2 ? 1 : 0;
        }

        // Update the game board
        for (i = 0; i < MAX_CELLS; i++)
        {
            for (j = 0; j < MAX_CELLS; j++)
            {
                board[i][j] = cells[i] ? '#' : ' ';
            }
        }

        // Print the game board
        printf("Generation %d:\n", generation++);
        for (i = 0; i < MAX_CELLS; i++)
        {
            for (j = 0; j < MAX_CELLS; j++)
            {
                printf("%c ", board[i][j]);
            }
            printf("\n");
        }
    }

    return 0;
}