//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: ephemeral
// Ephemeral TCP/IP Programming Example

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>

int main(int argc, char *argv[]) {
    int sockfd, new_fd;
    struct sockaddr_in serv_addr, cli_addr;
    socklen_t clilen;
    char buffer[256];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(1234);

    // Bind the socket to the address
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for incoming connections
    listen(sockfd, 3);

    // Accept an incoming connection
    clilen = sizeof(cli_addr);
    new_fd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);
    if (new_fd < 0) {
        perror("Error accepting connection");
        exit(1);
    }

    // Read from the client
    if (read(new_fd, buffer, 255) < 0) {
        perror("Error reading from client");
        exit(1);
    }

    // Send a response to the client
    if (send(new_fd, "Hello, client!", 13, 0) < 0) {
        perror("Error sending response");
        exit(1);
    }

    // Close the connection
    close(new_fd);
    close(sockfd);

    return 0;
}