//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 20
#define MAX_FILE_SIZE 100

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    int size;
    char data[MAX_FILE_SIZE];
} File;

int num_files = 0;
File files[MAX_FILES];

void create_file(char *name) {
    if (num_files >= MAX_FILES) {
        printf("Error: Cannot create file. Maximum number of files reached.\n");
        return;
    }
    strcpy(files[num_files].name, name);
    files[num_files].size = 0;
    num_files++;
}

void delete_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(files[i].data, 0, MAX_FILE_SIZE);
            strcpy(files[i].name, "");
            files[i].size = 0;
            num_files--;
            return;
        }
    }
    printf("Error: File not found.\n");
}

void write_to_file(char *name, char *data) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            if (files[i].size >= MAX_FILE_SIZE) {
                printf("Error: File is full.\n");
                return;
            }
            strcat(files[i].data, data);
            files[i].size += strlen(data);
            return;
        }
    }
    printf("Error: File not found.\n");
}

void read_from_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("%s\n", files[i].data);
            return;
        }
    }
    printf("Error: File not found.\n");
}

int main() {
    create_file("test.txt");
    write_to_file("test.txt", "Hello, world!");
    read_from_file("test.txt");
    delete_file("test.txt");
    return 0;
}