//GEMINI-pro DATASET v1.0 Category: Drone Remote Control ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRONE_MIN_HEIGHT 0
#define DRONE_MAX_HEIGHT 100

typedef struct {
    int x;
    int y;
    int z;
} point_t;

typedef struct {
    point_t position;
    int speed;
    int direction;
} drone_t;

void print_drone(drone_t *drone) {
    printf("Drone position: (%d, %d, %d)\n", drone->position.x, drone->position.y, drone->position.z);
    printf("Drone speed: %d\n", drone->speed);
    printf("Drone direction: %d\n", drone->direction);
}

void move_drone(drone_t *drone, int dx, int dy, int dz) {
    drone->position.x += dx;
    drone->position.y += dy;
    drone->position.z += dz;
}

void rotate_drone(drone_t *drone, int direction) {
    drone->direction = direction;
}

void set_drone_speed(drone_t *drone, int speed) {
    drone->speed = speed;
}

int main() {
    drone_t drone;

    drone.position.x = 0;
    drone.position.y = 0;
    drone.position.z = 0;
    drone.speed = 0;
    drone.direction = 0;

    print_drone(&drone);

    move_drone(&drone, 10, 20, 30);
    print_drone(&drone);

    rotate_drone(&drone, 90);
    print_drone(&drone);

    set_drone_speed(&drone, 50);
    print_drone(&drone);

    return 0;
}