//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: happy
#include <stdio.h>
#include <stdlib.h>

// Process structure
typedef struct Process {
    int pid;             // Process ID
    int arrival_time;    // Arrival time
    int burst_time;      // Burst time
    int waiting_time;    // Waiting time
    int turnaround_time; // Turnaround time
} Process;

// Function to find the waiting time for a process
int waiting_time(Process *p, int n) {
    p[0].waiting_time = 0;
    for (int i = 1; i < n; i++) {
        p[i].waiting_time = p[i - 1].waiting_time + p[i - 1].burst_time;
    }
}

// Function to find the turnaround time for a process
int turnaround_time(Process *p, int n) {
    for (int i = 0; i < n; i++) {
        p[i].turnaround_time = p[i].waiting_time + p[i].burst_time;
    }
}

// Function to find the average waiting time for a set of processes
float avg_waiting_time(Process *p, int n) {
    waiting_time(p, n);
    float total_waiting_time = 0;
    for (int i = 0; i < n; i++) {
        total_waiting_time += p[i].waiting_time;
    }
    return total_waiting_time / n;
}

// Function to find the average turnaround time for a set of processes
float avg_turnaround_time(Process *p, int n) {
    turnaround_time(p, n);
    float total_turnaround_time = 0;
    for (int i = 0; i < n; i++) {
        total_turnaround_time += p[i].turnaround_time;
    }
    return total_turnaround_time / n;
}

// Function to print the Gantt chart for a set of processes
void print_gantt_chart(Process *p, int n) {
    printf("\nGantt Chart:\n");
    printf("--------------------------------------------------------------------\n");
    for (int i = 0; i < n; i++) {
        printf("| P%d |", p[i].pid);
    }
    printf("\n--------------------------------------------------------------------\n");
    int total_time = 0;
    for (int i = 0; i < n; i++) {
        printf("| %d |", total_time);
        total_time += p[i].burst_time;
    }
    printf("\n--------------------------------------------------------------------\n");
}

// Function to print the details of a set of processes
void print_process_details(Process *p, int n) {
    printf("\nProcess Details:\n");
    printf("--------------------------------------------------------------------\n");
    printf("%-5s %-15s %-15s %-15s %-15s %-15s\n", "PID", "Arrival Time", "Burst Time", "Waiting Time", "Turnaround Time", "Response Time");
    printf("--------------------------------------------------------------------\n");
    for (int i = 0; i < n; i++) {
        printf("%-5d %-15d %-15d %-15d %-15d %-15d\n", p[i].pid, p[i].arrival_time, p[i].burst_time, p[i].waiting_time, p[i].turnaround_time, p[i].waiting_time);
    }
    printf("--------------------------------------------------------------------\n");
}

// Main function
int main() {
    // Create a set of processes
    Process p[] = {{1, 0, 5}, {2, 2, 3}, {3, 4, 6}, {4, 6, 4}};
    int n = sizeof(p) / sizeof(p[0]);

    // Find the average waiting time and average turnaround time for the set of processes
    float avg_waiting = avg_waiting_time(p, n);
    float avg_turnaround = avg_turnaround_time(p, n);

    // Print the Gantt chart for the set of processes
    print_gantt_chart(p, n);

    // Print the details of the set of processes
    print_process_details(p, n);

    // Print the average waiting time and average turnaround time for the set of processes
    printf("\nAverage Waiting Time: %.2f\n", avg_waiting);
    printf("Average Turnaround Time: %.2f\n", avg_turnaround);

    return 0;
}