//Falcon-180B DATASET v1.0 Category: Data structures visualization ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Define the maximum size for the stack
#define MAX_SIZE 100

// Define the structure for the stack
typedef struct {
    int arr[MAX_SIZE];
    int top;
} Stack;

// Initialize the stack
void init(Stack* s) {
    s->top = -1;
}

// Push an element onto the stack
void push(Stack* s, int value) {
    if (s->top >= MAX_SIZE - 1) {
        printf("Stack is full!\n");
        return;
    }
    s->arr[++s->top] = value;
}

// Pop an element from the stack
int pop(Stack* s) {
    if (s->top < 0) {
        printf("Stack is empty!\n");
        return -1;
    }
    return s->arr[s->top--];
}

// Print the stack
void print(Stack* s) {
    if (s->top < 0) {
        printf("Stack is empty!\n");
        return;
    }
    printf("Stack: ");
    for (int i = s->top; i >= 0; i--) {
        printf("%d ", s->arr[i]);
    }
    printf("\n");
}

// Main function
int main() {
    Stack s;
    init(&s);

    // Push elements onto the stack
    push(&s, 10);
    push(&s, 20);
    push(&s, 30);
    push(&s, 40);

    // Print the stack
    print(&s);

    // Pop elements from the stack
    int val = pop(&s);
    printf("Popped element: %d\n", val);
    print(&s);

    return 0;
}