//Falcon2-11B DATASET v1.0 Category: Network Packet Monitoring ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    int sockfd, n;
    struct sockaddr_in serv_addr;
    char buffer[1024];

    // Create socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("ERROR opening socket");
        exit(EXIT_FAILURE);
    }

    // Create server address structure
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(8080);
    serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) == -1) {
        perror("ERROR connecting");
        exit(EXIT_FAILURE);
    }

    // Send request
    n = send(sockfd, "GET / HTTP/1.0\r\n\r\n", 38, 0);
    if (n == -1) {
        perror("ERROR sending request");
        exit(EXIT_FAILURE);
    }

    // Receive response
    bzero(buffer, sizeof(buffer));
    n = recv(sockfd, buffer, sizeof(buffer), 0);
    if (n == -1) {
        perror("ERROR receiving response");
        exit(EXIT_FAILURE);
    }

    // Print response
    printf("%s", buffer);

    close(sockfd);

    return 0;
}