//Falcon-180B DATASET v1.0 Category: Data structures visualization ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 100

typedef struct {
    char data[MAX_SIZE];
    int top;
} Stack;

void init(Stack *s) {
    s->top = -1;
}

int isEmpty(Stack *s) {
    return (s->top == -1);
}

int isFull(Stack *s) {
    return (s->top == MAX_SIZE - 1);
}

void push(Stack *s, char c) {
    if (isFull(s)) {
        printf("Stack overflow\n");
        exit(0);
    } else {
        s->top++;
        s->data[s->top] = c;
    }
}

char pop(Stack *s) {
    if (isEmpty(s)) {
        printf("Stack underflow\n");
        exit(0);
    } else {
        char c = s->data[s->top];
        s->top--;
        return c;
    }
}

void display(Stack *s) {
    if (isEmpty(s)) {
        printf("Stack is empty\n");
    } else {
        printf("Stack elements are:\n");
        for (int i = s->top; i >= 0; i--) {
            printf("%c ", s->data[i]);
        }
        printf("\n");
    }
}

int main() {
    Stack s;
    init(&s);

    push(&s, 'A');
    push(&s, 'B');
    push(&s, 'C');
    push(&s, 'D');
    push(&s, 'E');

    display(&s);

    char c = pop(&s);
    printf("Popped element is: %c\n", c);

    display(&s);

    push(&s, 'F');
    push(&s, 'G');

    display(&s);

    return 0;
}