//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_FILES 5
#define MAX_FILE_SIZE 1024

typedef struct {
    char filename[20];
    int size;
} file_t;

void init_files(file_t files[]) {
    int i;
    for(i=0; i<NUM_FILES; i++) {
        sprintf(files[i].filename, "file_%d.txt", i+1);
        files[i].size = rand() % MAX_FILE_SIZE + 1;
    }
}

void read_files(file_t files[]) {
    int i;
    for(i=0; i<NUM_FILES; i++) {
        FILE *fp = fopen(files[i].filename, "r");
        if(fp == NULL) {
            printf("Error: File %s not found.\n", files[i].filename);
            exit(1);
        }
        fclose(fp);
    }
}

void write_files(file_t files[]) {
    int i;
    for(i=0; i<NUM_FILES; i++) {
        FILE *fp = fopen(files[i].filename, "w");
        if(fp == NULL) {
            printf("Error: Could not create file %s.\n", files[i].filename);
            exit(1);
        }
        fprintf(fp, "This is file %s.\n", files[i].filename);
        fclose(fp);
    }
}

int main() {
    file_t files[NUM_FILES];
    init_files(files);
    read_files(files);
    write_files(files);
    return 0;
}