//Falcon2-11B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

typedef struct {
    int pid;
    int arrival_time;
    int burst_time;
    int cpu_time;
    int cpu_priority;
} Task;

Task tasks[10];
int num_tasks = 0;

void *task_func(void *arg) {
    Task *task = (Task *)arg;
    int cpu_time = task->burst_time;
    
    while (cpu_time > 0) {
        if (task->cpu_time < cpu_time) {
            task->cpu_time += cpu_time;
            task->burst_time -= cpu_time;
            cpu_time = 0;
        } else {
            task->cpu_time -= cpu_time;
            task->burst_time -= cpu_time;
            cpu_time = 0;
        }
        sleep(1);
    }
    
    pthread_exit(NULL);
}

int main() {
    int i;
    int num_threads = 4;
    pthread_t threads[num_threads];
    
    for (i = 0; i < num_tasks; i++) {
        tasks[i].pid = i + 1;
        tasks[i].arrival_time = rand() % 100;
        tasks[i].burst_time = rand() % 100;
        tasks[i].cpu_time = 0;
        tasks[i].cpu_priority = rand() % 100;
    }
    
    for (i = 0; i < num_tasks; i++) {
        Task *task = &tasks[i];
        if (task->arrival_time == 0) {
            task->arrival_time = rand() % 100;
        }
        if (task->burst_time == 0) {
            task->burst_time = rand() % 100;
        }
    }
    
    for (i = 0; i < num_threads; i++) {
        pthread_create(&threads[i], NULL, task_func, &tasks[i]);
    }
    
    for (i = 0; i < num_threads; i++) {
        pthread_join(threads[i], NULL);
    }
    
    printf("Task\tArrival Time\tBurst Time\tCPU Time\n");
    for (i = 0; i < num_tasks; i++) {
        Task *task = &tasks[i];
        printf("%d\t%d\t%d\t%d\n", task->pid, task->arrival_time, task->burst_time, task->cpu_time);
    }
    
    return 0;
}