//GEMINI-pro DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Data structures for storing alien invasion probabilities
typedef struct {
    double probability;
    char *description;
} InvasionProbability;

// Function to calculate alien invasion probability based on Drake equation
double calculateInvasionProbability(double stars, double planetsPerStar, double lifeBearingPlanetsPerPlanet, double intelligentLifePerLifeBearingPlanet, double civilizationsPerIntelligentLife, double communicationPerCivilization, double yearsPerCommunicationEvent) {
    return stars * planetsPerStar * lifeBearingPlanetsPerPlanet * intelligentLifePerLifeBearingPlanet * civilizationsPerIntelligentLife * communicationPerCivilization * yearsPerCommunicationEvent;
}

// Function to print alien invasion probabilities
void printInvasionProbabilities(InvasionProbability probabilities[], int numProbabilities) {
    for (int i = 0; i < numProbabilities; i++) {
        printf("%s: %.2f%%\n", probabilities[i].description, probabilities[i].probability * 100);
    }
}

int main() {
    // Define input parameters for Drake equation
    double stars = 1000000000000; // Number of stars in the Milky Way galaxy
    double planetsPerStar = 1; // Average number of planets per star
    double lifeBearingPlanetsPerPlanet = 0.1; // Fraction of planets that can support life
    double intelligentLifePerLifeBearingPlanet = 0.01; // Fraction of life-bearing planets that develop intelligent life
    double civilizationsPerIntelligentLife = 0.001; // Fraction of intelligent species that develop civilizations
    double communicationPerCivilization = 0.0001; // Fraction of civilizations that communicate with us
    double yearsPerCommunicationEvent = 10000; // Average time between communication events

    // Calculate alien invasion probability
    double probability = calculateInvasionProbability(stars, planetsPerStar, lifeBearingPlanetsPerPlanet, intelligentLifePerLifeBearingPlanet, civilizationsPerIntelligentLife, communicationPerCivilization, yearsPerCommunicationEvent);

    // Define invasion probability descriptions
    char *descriptions[] = {
        "Very unlikely",
        "Unlikely",
        "Possible",
        "Likely",
        "Very likely",
        "Almost certain",
    };

    // Create array of invasion probabilities
    InvasionProbability probabilities[] = {
        {0.001, descriptions[0]},
        {0.01, descriptions[1]},
        {0.1, descriptions[2]},
        {0.5, descriptions[3]},
        {0.9, descriptions[4]},
        {0.99, descriptions[5]},
    };

    // Find the probability range that the calculated probability falls into
    int probabilityRange = -1;
    for (int i = 0; i < 6; i++) {
        if (probability >= probabilities[i].probability) {
            probabilityRange = i;
            break;
        }
    }

    // Print the invasion probability
    if (probabilityRange == -1) {
        printf("Alien invasion is extremely unlikely.\n");
    } else {
        printf("Alien invasion probability: %s\n", probabilities[probabilityRange].description);
    }

    return 0;
}