//GPT-4o-mini DATASET v1.0 Category: Temperature monitor ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <string.h>

#define SAFE_TEMP_MIN 15.0   // Minimum safe temperature
#define SAFE_TEMP_MAX 30.0   // Maximum safe temperature
#define ALERT_TEMP 35.0      // Temperature threshold for alerts
#define NUM_READINGS 10      // Number of readings to simulate
#define SLEEP_INTERVAL 2     // Time interval between readings in seconds

// Structure to hold temperature data
typedef struct {
    float temperature;
    time_t timestamp;
} TemperatureData;

// Global variables
TemperatureData readings[NUM_READINGS];
int current_index = 0;
pthread_mutex_t lock;

// Function to simulate reading temperature from a sensor
float read_temperature() {
    // Simulate fluctuation in temperature readings
    return ((float)(rand() % 401) / 10.0) - 10.0; // Range from -10 to 40
}

// Function to check the temperature and generate alerts
void* monitor_temperature(void* arg) {
    while (current_index < NUM_READINGS) {
        // Simulated temperature reading
        float temp = read_temperature();
        
        // Lock the mutex before modifying the readings
        pthread_mutex_lock(&lock);
        
        // Store the reading
        readings[current_index].temperature = temp;
        readings[current_index].timestamp = time(NULL);
        
        printf("Reading[%d]: %.2f°C at %s", current_index, temp, ctime(&readings[current_index].timestamp));
        
        // Check if the temperature is out of safe bounds
        if (temp > ALERT_TEMP) {
            printf("ALERT: High temperature detected! %.2f°C at %s", temp, ctime(&readings[current_index].timestamp));
        } else if (temp < SAFE_TEMP_MIN || temp > SAFE_TEMP_MAX) {
            printf("WARNING: Temperature is outside of safe range! %.2f°C at %s", temp, ctime(&readings[current_index].timestamp));
        }

        current_index++;
        
        // Unlock the mutex after updating the readings
        pthread_mutex_unlock(&lock);

        // Wait for the next reading
        sleep(SLEEP_INTERVAL);
    }
    return NULL;
}

int main() {
    srand(time(NULL)); // Seed the random number generator
    pthread_t monitor_thread;

    // Initialize the mutex
    if (pthread_mutex_init(&lock, NULL) != 0) {
        fprintf(stderr, "Mutex initialization failed\n");
        return 1;
    }

    // Create a thread to monitor temperature
    if (pthread_create(&monitor_thread, NULL, monitor_temperature, NULL) != 0) {
        fprintf(stderr, "Thread creation failed\n");
        return 1;
    }

    // Wait for the monitor thread to finish
    pthread_join(monitor_thread, NULL);

    // Cleanup
    pthread_mutex_destroy(&lock);

    printf("Temperature monitoring complete. Collected %d readings:\n", current_index);
    for (int i = 0; i < current_index; i++) {
        printf("Reading[%d]: %.2f°C at %s", i, readings[i].temperature, ctime(&readings[i].timestamp));
    }

    return 0;
}