//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>

int main() {

    int sockfd, newsockfd, portno, clilen, sd;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[1024];
    char *message;
    int max_cli;
    int val;
    struct timeval timeout;

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set timeout
    timeout.tv_sec = 5;
    timeout.tv_usec = 0;

    // Set reuse address option
    val = 1;
    setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val));

    // Bind to local address and port
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(12345);

    // Bind to port
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    listen(sockfd, 5);

    // Accept a connection
    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);

    if (newsockfd < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Send message to client
    message = "What light through yonder window breaks?\n";
    send(newsockfd, message, strlen(message), 0);

    // Receive message from client
    sd = setsockopt(newsockfd, SOL_SOCKET, SO_RCVTIMEO, &timeout, sizeof(timeout));
    if (sd < 0) {
        perror("setsockopt failed");
        exit(EXIT_FAILURE);
    }

    sd = recv(newsockfd, buffer, sizeof(buffer), 0);
    if (sd < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Received message: %s\n", buffer);

    // Close sockets
    close(newsockfd);
    close(sockfd);

    return 0;
}