//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: Ken Thompson
/* Ken Thompson's Socket Programming Example */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

int main() {
    int sock;
    struct sockaddr_in server_addr;
    char *message = "Hello, World!";
    char recv_buffer[1024];

    /* Create a socket */
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket()");
        exit(1);
    }

    /* Set up the server address */
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(1234);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    /* Connect to the server */
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect()");
        exit(1);
    }

    /* Send a message to the server */
    if (send(sock, message, strlen(message), 0) < 0) {
        perror("send()");
        exit(1);
    }

    /* Receive a message from the server */
    if (recv(sock, recv_buffer, sizeof(recv_buffer), 0) < 0) {
        perror("recv()");
        exit(1);
    }

    /* Print the message received from the server */
    printf("Received message: %s\n", recv_buffer);

    /* Close the socket */
    if (close(sock) < 0) {
        perror("close()");
        exit(1);
    }

    return 0;
}