//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Constants for our circuit simulator
#define MAX_COMPONENTS 100
#define MAX_NAME_LENGTH 30

// Enumeration for component types
typedef enum {
    RESISTOR,
    CAPACITOR,
    INDUCTOR,
    VOLTAGE_SOURCE,
    CURRENT_SOURCE
} ComponentType;

// Structure for an electrical component
typedef struct {
    ComponentType type;
    char name[MAX_NAME_LENGTH];
    double value; // Ohms for resistors, Farads for capacitors, Henries for inductors, Volts for sources
} Component;

// Structure for a circuit
typedef struct {
    Component components[MAX_COMPONENTS];
    int component_count;
} Circuit;

// Function prototypes
void add_component(Circuit *circuit, ComponentType type, const char *name, double value);
void show_circuit(Circuit *circuit);
void calculate_total_resistance(Circuit *circuit);

int main() {
    Circuit my_circuit = {.component_count = 0};

    printf("Welcome to the Exciting Circuit Simulator!\n");

    // Adding components
    add_component(&my_circuit, RESISTOR, "R1", 100.0);
    add_component(&my_circuit, RESISTOR, "R2", 200.0);
    add_component(&my_circuit, CAPACITOR, "C1", 0.001);
    add_component(&my_circuit, VOLTAGE_SOURCE, "V1", 12.0);
    add_component(&my_circuit, INDUCTOR, "L1", 0.1);
    
    show_circuit(&my_circuit);

    calculate_total_resistance(&my_circuit);

    return 0;
}

// Function to add a component to the circuit
void add_component(Circuit *circuit, ComponentType type, const char *name, double value) {
    if (circuit->component_count < MAX_COMPONENTS) {
        circuit->components[circuit->component_count].type = type;
        strncpy(circuit->components[circuit->component_count].name, name, MAX_NAME_LENGTH);
        circuit->components[circuit->component_count].value = value;
        circuit->component_count++;
        printf("Component added: %s\n", name);
    } else {
        printf("Error: Circuit has reached maximum number of components!\n");
    }
}

// Function to show all components in the circuit
void show_circuit(Circuit *circuit) {
    printf("\nCurrent Circuit Composition:\n");
    for (int i = 0; i < circuit->component_count; i++) {
        Component comp = circuit->components[i];
        const char *type_str;
        switch (comp.type) {
            case RESISTOR: type_str = "Resistor"; break;
            case CAPACITOR: type_str = "Capacitor"; break;
            case INDUCTOR: type_str = "Inductor"; break;
            case VOLTAGE_SOURCE: type_str = "Voltage Source"; break;
            case CURRENT_SOURCE: type_str = "Current Source"; break;
            default: type_str = "Unknown"; break;
        }
        printf(" - %s (%s): %.2f\n", comp.name, type_str, comp.value);
    }
}

// Function to calculate total resistance in series
void calculate_total_resistance(Circuit *circuit) {
    double total_resistance = 0.0;
    int resistor_count = 0;

    for (int i = 0; i < circuit->component_count; i++) {
        if (circuit->components[i].type == RESISTOR) {
            total_resistance += circuit->components[i].value;
            resistor_count++;
        }
    }

    if (resistor_count == 0) {
        printf("No resistors in the circuit, cannot calculate total resistance.\n");
    } else {
        printf("\nTotal Resistance of the resistors in series: %.2f Ohms\n", total_resistance);
    }
}