//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>

#define MAX_SIZE 1024
#define KEY 1234
#define SEM_ID 1
#define SHM_ID 2

int shmid;
char *shm;

int main() {
    int semid;
    int msgid;
    int status;
    pid_t pid;

    // Create shared memory
    shmid = shmget(KEY, MAX_SIZE, 0666 | IPC_CREAT);
    if (shmid == -1) {
        printf("Error: Could not create shared memory.\n");
        exit(1);
    }
    shm = (char *) shmat(shmid, NULL, 0);
    if (shm == (char *) -1) {
        printf("Error: Could not attach to shared memory.\n");
        exit(1);
    }

    // Create semaphore
    semid = semget(KEY, 1, 0666 | IPC_CREAT);
    if (semid == -1) {
        printf("Error: Could not create semaphore.\n");
        exit(1);
    }

    // Create message queue
    msgid = msgget(KEY, 0666 | IPC_CREAT);
    if (msgid == -1) {
        printf("Error: Could not create message queue.\n");
        exit(1);
    }

    // Fork child process
    pid = fork();
    if (pid == -1) {
        printf("Error: Could not fork child process.\n");
        exit(1);
    } else if (pid == 0) {
        // Child process
        sleep(1);
        sprintf(shm, "Hello from child process %d.", getpid());
        printf("Child process %d wrote to shared memory.\n", getpid());
        semctl(semid, 0, SETVAL, 1);
        msgsnd(msgid, shm, MAX_SIZE, 0);
        exit(0);
    } else {
        // Parent process
        waitpid(pid, &status, 0);
        printf("Child process %d terminated.\n", pid);
        semctl(semid, 0, GETVAL);
        msgrcv(msgid, shm, MAX_SIZE, 0, 0);
        printf("Parent process received message: %s", shm);
    }

    return 0;
}