//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS 10

typedef struct process {
  int pid;
  int burst_time;
  int waiting_time;
  int turnaround_time;
} process;

process processes[MAX_PROCESS];

void schedule_process() {
  int i, j, current_time = 0, quantum = 5;
  processes[0].waiting_time = 0;
  for (i = 1; i < MAX_PROCESS; i++) {
    processes[i].waiting_time = current_time + quantum;
  }

  for (i = 0; i < MAX_PROCESS; i++) {
    for (j = i + 1; j < MAX_PROCESS; j++) {
      if (processes[i].waiting_time > processes[j].waiting_time) {
        process temp = processes[i];
        processes[i] = processes[j];
        processes[j] = temp;
      }
    }
  }

  current_time += quantum;
  for (i = 0; i < MAX_PROCESS; i++) {
    processes[i].turnaround_time = current_time + processes[i].burst_time;
  }
}

int main() {
  int i, total_time = 0, total_waiting_time = 0;
  for (i = 0; i < MAX_PROCESS; i++) {
    processes[i].pid = i;
    processes[i].burst_time = rand() % 5 + 1;
    processes[i].waiting_time = 0;
    processes[i].turnaround_time = 0;
  }

  schedule_process();

  for (i = 0; i < MAX_PROCESS; i++) {
    total_time += processes[i].turnaround_time;
    total_waiting_time += processes[i].waiting_time;
  }

  printf("Total time: %d\n", total_time);
  printf("Total waiting time: %d\n", total_waiting_time);

  return 0;
}