//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>

#define PORT 12345

struct sockaddr_in servaddr, cliaddr;

void send_data(int sockfd, char *data, int len) {
    int sent = send(sockfd, data, len, 0);
    if (sent < 0) {
        perror("send");
        exit(1);
    }
}

char recv_data(int sockfd, char *buffer, int buflen) {
    int len = recv(sockfd, buffer, buflen, 0);
    if (len < 0) {
        perror("recv");
        exit(1);
    }
    return len;
}

void close_socket(int sockfd) {
    if (close(sockfd) < 0) {
        perror("close");
        exit(1);
    }
}

int main(int argc, char *argv[]) {
    int sockfd, new_sockfd;
    struct sockaddr_in servaddr, cliaddr;
    char buffer[1024];
    socklen_t clilen = sizeof(cliaddr);

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket");
        exit(1);
    }

    // Bind the socket to a port
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servaddr.sin_port = htons(PORT);

    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("bind");
        exit(1);
    }

    // Listen for connections
    if (listen(sockfd, 5) < 0) {
        perror("listen");
        exit(1);
    }

    // Accept incoming connections
    if ((new_sockfd = accept(sockfd, (struct sockaddr *)&cliaddr, &clilen)) < 0) {
        perror("accept");
        exit(1);
    }

    // Send data to the client
    send_data(new_sockfd, "Hello, client!", 17);

    // Receive data from the client
    recv_data(new_sockfd, buffer, sizeof(buffer));
    printf("Received: %s\n", buffer);

    // Close the socket
    close_socket(new_sockfd);

    return 0;
}