//GEMINI-pro DATASET v1.0 Category: Performance-Critical Component ; Style: Donald Knuth
// Preprocessors are the first to be called, and we define a macro for brevity.
#define min(a, b) (((a) < (b)) ? (a) : (b))

// The header file stdio.h includes the standard input/output library, which provides functions like printf and scanf.
#include <stdio.h>

// The header file stdlib.h includes the standard library, which provides functions like malloc and free.
#include <stdlib.h>

// The following function calculates the minimum of two numbers.
int minimum(int a, int b) {
  // The ternary operator is a shorthand for an if-else statement.
  return (a < b) ? a : b;
}

// The following function calculates the maximum of two numbers.
int maximum(int a, int b) {
  return (a > b) ? a : b;
}

// The following function calculates the absolute value of a number.
int absolute(int a) {
  return (a < 0) ? -a : a;
}

// The following function calculates the square root of a number.
double square_root(double a) {
  // The initial guess is the average of the number and 1.
  double guess = (a + 1) / 2;
  // The following loop iterates until the guess is close enough to the square root of the number.
  while (absolute(guess * guess - a) > 1e-6) {
    // The next guess is the average of the current guess and the number divided by the current guess.
    guess = (guess + a / guess) / 2;
  }
  return guess;
}

// The following function calculates the factorial of a number.
int factorial(int n) {
  // The base case is when n is equal to 1.
  if (n == 1) {
    return 1;
  }
  // The recursive case is when n is greater than 1.
  else {
    return n * factorial(n - 1);
  }
}

// The following function calculates the fibonacci sequence.
int fibonacci(int n) {
  // The base case is when n is equal to 0 or 1.
  if (n == 0 || n == 1) {
    return 1;
  }
  // The recursive case is when n is greater than 1.
  else {
    return fibonacci(n - 1) + fibonacci(n - 2);
  }
}

// The following function calculates the number of divisors of a number.
int number_of_divisors(int n) {
  // The initial count of divisors is 1.
  int count = 1;
  // The following loop iterates from 2 to the square root of the number.
  for (int i = 2; i * i <= n; i++) {
    // If the number is divisible by the current index, then the count of divisors is incremented.
    if (n % i == 0) {
      count++;
    }
  }
  // The count of divisors is doubled because each divisor has a corresponding divisor that is the number divided by the current divisor.
  return count * 2;
}

// The following function calculates the sum of the digits of a number.
int sum_of_digits(int n) {
  // The initial sum of digits is 0.
  int sum = 0;
  // The following loop iterates until the number is 0.
  while (n != 0) {
    // The last digit of the number is added to the sum.
    sum += n % 10;
    // The number is divided by 10 to remove the last digit.
    n /= 10;
  }
  // The sum of the digits is returned.
  return sum;
}

// The following function calculates the number of trailing zeros in the binary representation of a number.
int number_of_trailing_zeros(int n) {
  // The initial count of trailing zeros is 0.
  int count = 0;
  // The following loop iterates until the number is 0.
  while (n != 0) {
    // If the last bit of the number is 0, then the count of trailing zeros is incremented.
    if (n % 2 == 0) {
      count++;
    }
    // The number is shifted right by 1 bit to remove the last bit.
    n >>= 1;
  }
  // The count of trailing zeros is returned.
  return count;
}

// The following function calculates the greatest common divisor of two numbers.
int greatest_common_divisor(int a, int b) {
  // The base case is when b is 0.
  if (b == 0) {
    return a;
  }
  // The recursive case is when b is not 0.
  else {
    return greatest_common_divisor(b, a % b);
  }
}

// The following function calculates the least common multiple of two numbers.
int least_common_multiple(int a, int b) {
  return (a * b) / greatest_common_divisor(a, b);
}

int main() {
  // The following line prints the minimum of two numbers.
  printf("%d\n", minimum(3, 4));
  // The following line prints the maximum of two numbers.
  printf("%d\n", maximum(3, 4));
  // The following line prints the absolute value of a number.
  printf("%d\n", absolute(-3));
  // The following line prints the square root of a number.
  printf("%f\n", square_root(9));
  // The following line prints the factorial of a number.
  printf("%d\n", factorial(5));
  // The following line prints the fibonacci sequence.
  printf("%d\n", fibonacci(5));
  // The following line prints the number of divisors of a number.
  printf("%d\n", number_of_divisors(12));
  // The following line prints the sum of the digits of a number.
  printf("%d\n", sum_of_digits(123));
  // The following line prints the number of trailing zeros in the binary representation of a number.
  printf("%d\n", number_of_trailing_zeros(12));
  // The following line prints the greatest common divisor of two numbers.
  printf("%d\n", greatest_common_divisor(12, 18));
  // The following line prints the least common multiple of two numbers.
  printf("%d\n", least_common_multiple(12, 18));
  return 0;
}