//GEMINI-pro DATASET v1.0 Category: Audio processing ; Style: statistical
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <portaudio.h>

typedef struct {
    double mean;
    double variance;
} stats_t;

static int paCallback(const void *inputBuffer, void *outputBuffer,
                      unsigned long framesPerBuffer,
                      const PaStreamCallbackTimeInfo* timeInfo,
                      PaStreamCallbackFlags statusFlags,
                      void *userData)
{
    const float *in = (const float *)inputBuffer;
    float *out = (float *)outputBuffer;
    unsigned int i;
    (void) timeInfo; /* Prevent unused variable warning. */
    (void) statusFlags; /* Prevent unused variable warning. */
    (void) userData; /* Prevent unused variable warning. */

    stats_t stats = {0, 0};

    for (i = 0; i < framesPerBuffer; i++) {
        stats.mean += in[i];
        stats.variance += in[i] * in[i];
    }

    stats.mean /= framesPerBuffer;
    stats.variance = sqrt(stats.variance / framesPerBuffer - stats.mean * stats.mean);

    for (i = 0; i < framesPerBuffer; i++) {
        out[i] = (in[i] - stats.mean) / stats.variance;
    }

    return 0;
}

int main(void)
{
    PaStream *stream;
    PaError err;

    err = Pa_Initialize();
    if (err != paNoError) goto error;

    err = Pa_OpenDefaultStream(&stream, 1, 1, paFloat32, 44100, 512, paCallback, NULL);
    if (err != paNoError) goto error;

    err = Pa_StartStream(stream);
    if (err != paNoError) goto error;

    printf("Press Enter to stop.\n");
    getchar();

    err = Pa_StopStream(stream);
    if (err != paNoError) goto error;

    err = Pa_CloseStream(stream);
    if (err != paNoError) goto error;

    Pa_Terminate();

    return 0;

error:
    Pa_Terminate();
    fprintf(stderr, "An error occured: %s\n", Pa_GetErrorText(err));
    return err;
}