//GEMINI-pro DATASET v1.0 Category: Audio processing ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <portaudio.h>

#define NUM_SECONDS   (5)
#define SAMPLE_RATE   (44100)
#define FRAMES_PER_BUFFER  (64)

#ifndef M_PI
#define M_PI  (3.14159265)
#endif

typedef struct {
    float frequency;
    float amplitude;
    float phase;
} SineWave;

SineWave sineWaves[] = {
    { 440.0, 0.5, 0.0 },
    { 880.0, 0.5, 0.0 },
    { 1760.0, 0.5, 0.0 }
};

int numSineWaves = sizeof(sineWaves) / sizeof(SineWave);

// Function to generate a sine wave
float generateSineWave(SineWave *sineWave, float time) {
    return sineWave->amplitude * sin(2 * M_PI * sineWave->frequency * time + sineWave->phase);
}

// Callback function for PortAudio
int callback( const void *inputBuffer, void *outputBuffer,
                unsigned long framesPerBuffer,
                const PaStreamCallbackTimeInfo* timeInfo,
                PaStreamCallbackFlags statusFlags,
                void *userData ) {
    float *out = (float*)outputBuffer;

    // Generate the sine waves
    for (int i = 0; i < framesPerBuffer; i++) {
        float time = (float)i / SAMPLE_RATE;
        for (int j = 0; j < numSineWaves; j++) {
            out[i] += generateSineWave(&sineWaves[j], time);
        }
    }

    return 0;
}

int main(int argc, char *argv[]) {
    // Initialize PortAudio
    PaStream *stream;
    PaError err = Pa_Initialize();
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return -1;
    }

    // Open the audio stream
    err = Pa_OpenStream(&stream,
                        NULL,              // No input
                        1,                  // 1 channel
                        paFloat32,         // 32-bit floating point
                        SAMPLE_RATE,        // Sample rate
                        FRAMES_PER_BUFFER,  // Frames per buffer
                        callback,           // Callback function
                        sineWaves);         // User data

    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return -1;
    }

    // Start the audio stream
    err = Pa_StartStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return -1;
    }

    // Wait for a few seconds
    Pa_Sleep(NUM_SECONDS * 1000);

    // Stop the audio stream
    err = Pa_StopStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return -1;
    }

    // Close the audio stream
    err = Pa_CloseStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return -1;
    }

    // Terminate PortAudio
    Pa_Terminate();

    return 0;
}