//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: active
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_CARS 10
#define MAX_LANE 3

typedef struct Car {
    int lane;
    int position;
    int speed;
    int direction;
} Car;

Car cars[MAX_CARS];

void initializeCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        cars[i].lane = rand() % MAX_LANE;
        cars[i].position = rand() % 1000;
        cars[i].speed = rand() % 10;
        cars[i].direction = rand() % 2;
    }
}

void moveCars() {
    for (int i = 0; i < MAX_CARS; i++) {
        switch (cars[i].direction) {
            case 0:
                cars[i].position++;
                break;
            case 1:
                cars[i].position--;
                break;
        }

        if (cars[i].position > 1000) {
            cars[i].position = 0;
        } else if (cars[i].position < 0) {
            cars[i].position = 1000;
        }

        switch (cars[i].lane) {
            case 0:
                printf("Car %d is on lane 0, position %d, speed %d\n", i, cars[i].position, cars[i].speed);
                break;
            case 1:
                printf("Car %d is on lane 1, position %d, speed %d\n", i, cars[i].position, cars[i].speed);
                break;
            case 2:
                printf("Car %d is on lane 2, position %d, speed %d\n", i, cars[i].position, cars[i].speed);
                break;
        }
    }
}

int main() {
    initializeCars();
    moveCars();

    return 0;
}