//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Struct to hold appointment information
typedef struct {
    int id;
    time_t start_time;
    time_t end_time;
    char* description;
} Appointment;

// Function to compare appointment start times
int compare_start_times(const void* a, const void* b) {
    const Appointment* appointment_a = (const Appointment*)a;
    const Appointment* appointment_b = (const Appointment*)b;
    return difftime(appointment_a->start_time, appointment_b->start_time);
}

// Function to print appointment information
void print_appointment(const Appointment* appointment) {
    printf("ID: %d\n", appointment->id);
    printf("Start Time: %s\n", ctime(&appointment->start_time));
    printf("End Time: %s\n", ctime(&appointment->end_time));
    printf("Description: %s\n", appointment->description);
}

// Function to schedule appointments
void schedule_appointments(Appointment* appointments, int num_appointments) {
    qsort(appointments, num_appointments, sizeof(Appointment), compare_start_times);

    for (int i = 0; i < num_appointments; i++) {
        print_appointment(&appointments[i]);
    }
}

int main() {
    // Example appointments
    Appointment appointments[] = {
        {1, 1632966400, 1632972800, "Meeting with John"},
        {2, 1632976400, 1632982800, "Lunch with Jane"},
        {3, 1632986400, 1632992800, "Doctor's appointment"},
        {4, 1632996400, 1633002800, "Gym session"},
        {5, 1633006400, 1633012800, "Dinner with friends"}
    };

    // Schedule appointments
    schedule_appointments(appointments, sizeof(appointments) / sizeof(Appointment));

    return 0;
}