//GPT-4o-mini DATASET v1.0 Category: Audio processing ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <portaudio.h>

#define SAMPLE_RATE 44100
#define FRAMES_PER_BUFFER 256
#define VOLUME_ADJUSTMENT 0.5f  // Volume adjustment factor (0.0 to 1.0)

typedef struct {
    float volume;
} AudioData;

static int audioCallback(const void *inputBuffer, 
                         void *outputBuffer,
                         unsigned long framesPerBuffer,
                         const PaStreamCallbackTimeInfo *timeInfo,
                         PaStreamCallbackFlags statusFlags,
                         void *userData) {
    AudioData *data = (AudioData *)userData;
    float *in = (float *)inputBuffer;
    float *out = (float *)outputBuffer;
    unsigned int i;

    for (i = 0; i < framesPerBuffer; i++) {
        // Apply volume adjustment
        *out++ = (*in++) * data->volume;  // Left channel
        *out++ = (*in++) * data->volume;  // Right channel
    }

    return paContinue;
}

int main(void) {
    PaError err;
    AudioData data;
    data.volume = VOLUME_ADJUSTMENT;

    err = Pa_Initialize();
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        return EXIT_FAILURE;
    }

    PaStream *stream;
    err = Pa_OpenDefaultStream(&stream,
                               2, // input channels
                               2, // output channels
                               paFloat32, // sample format
                               SAMPLE_RATE,
                               FRAMES_PER_BUFFER,
                               audioCallback,
                               &data);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        Pa_Terminate();
        return EXIT_FAILURE;
    }

    err = Pa_StartStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
        Pa_CloseStream(stream);
        Pa_Terminate();
        return EXIT_FAILURE;
    }

    printf("Press Enter to stop the stream...\n");
    getchar();  // Wait for user input

    err = Pa_StopStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
    }

    err = Pa_CloseStream(stream);
    if (err != paNoError) {
        fprintf(stderr, "PortAudio error: %s\n", Pa_GetErrorText(err));
    }

    Pa_Terminate();
    printf("Stream successfully stopped and terminated.\n");
    return EXIT_SUCCESS;
}