//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 8 // number of cards
#define MAX_TRIES 3 // maximum number of tries
#define DELAY 100000 // delay in microseconds

int cards[SIZE]; // array of cards
int tries; // number of tries left
int matches; // number of matches found
int selection; // user's selection
int flag; // flag to check if game is won or lost

void init_cards();
void display_cards();
void shuffle_cards();
int check_match(int card1, int card2);
void game_over();

int main() {
    srand(time(NULL)); // seed the random number generator
    init_cards(); // initialize the cards
    display_cards(); // display the cards
    shuffle_cards(); // shuffle the cards
    while (matches < SIZE && tries > 0) {
        printf("Enter the number of the first card: ");
        scanf("%d", &selection);
        if (selection >= 1 && selection <= SIZE) {
            flag = 0;
            for (int i = 0; i < SIZE; i++) {
                if (cards[i] == selection && cards[i]!= -1) {
                    cards[i] = -1;
                    if (i!= selection - 1) {
                        cards[selection - 1] = -1;
                    }
                    matches++;
                    flag = 1;
                    break;
                }
            }
            if (!flag) {
                tries--;
            }
        } else {
            printf("Invalid selection.\n");
        }
    }
    if (matches == SIZE) {
        game_over();
    } else {
        display_cards();
        printf("Game over. You lose.\n");
    }
    return 0;
}

void init_cards() {
    for (int i = 0; i < SIZE; i++) {
        cards[i] = i + 1;
    }
}

void display_cards() {
    printf("\n");
    for (int i = 0; i < SIZE; i++) {
        printf("%d ", cards[i]);
    }
    printf("\n");
}

void shuffle_cards() {
    for (int i = 0; i < SIZE; i++) {
        int j = rand() % SIZE;
        int temp = cards[i];
        cards[i] = cards[j];
        cards[j] = temp;
    }
}

int check_match(int card1, int card2) {
    return card1 == card2;
}

void game_over() {
    printf("\nCongratulations! You win!\n");
    for (int i = 0; i < SIZE; i++) {
        printf("%d ", cards[i]);
    }
    printf("\n");
}