//Falcon2-11B DATASET v1.0 Category: Task Scheduler ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>
#include <limits.h>
#include <signal.h>

// Task struct
typedef struct {
    int pid;
    char *task;
    int priority;
} Task;

// Function prototypes
void *task_func(void *arg);
void print_tasks(Task *tasks, int num_tasks);
void add_task(Task *tasks, int num_tasks, int priority, char *task);
void delete_task(Task *tasks, int num_tasks, int pid);
void set_task_priority(Task *tasks, int num_tasks, int pid, int priority);

// Main function
int main(int argc, char *argv[]) {
    // Initialize tasks array
    Task tasks[10];
    int num_tasks = 0;

    // Create a thread to handle tasks
    pthread_t thread;
    pthread_create(&thread, NULL, task_func, NULL);

    // Add tasks
    add_task(tasks, num_tasks, 1, "Task 1");
    add_task(tasks, num_tasks, 2, "Task 2");
    add_task(tasks, num_tasks, 3, "Task 3");

    // Wait for the thread to finish
    pthread_join(thread, NULL);

    // Print tasks
    print_tasks(tasks, num_tasks);

    // Delete task
    delete_task(tasks, num_tasks, 0);

    // Set task priority
    set_task_priority(tasks, num_tasks, 0, 2);

    // Print tasks
    print_tasks(tasks, num_tasks);

    // Exit program
    return 0;
}

// Task function
void *task_func(void *arg) {
    int i;
    for (i = 0; i < 10; i++) {
        // Do something
        printf("Task %d: Sleeping for 1 second...\n", i);
        sleep(1);
    }

    // Exit program
    return NULL;
}

// Function to print tasks
void print_tasks(Task *tasks, int num_tasks) {
    printf("Task 1: %s\n", tasks[0].task);
    printf("Task 2: %s\n", tasks[1].task);
    printf("Task 3: %s\n", tasks[2].task);
    printf("Task 4: %s\n", tasks[3].task);
    printf("Task 5: %s\n", tasks[4].task);
    printf("Task 6: %s\n", tasks[5].task);
    printf("Task 7: %s\n", tasks[6].task);
    printf("Task 8: %s\n", tasks[7].task);
    printf("Task 9: %s\n", tasks[8].task);
    printf("Task 10: %s\n", tasks[9].task);
}

// Function to add a task
void add_task(Task *tasks, int num_tasks, int priority, char *task) {
    int i;
    for (i = 0; i < num_tasks; i++) {
        if (strcmp(tasks[i].task, task) == 0) {
            printf("Task already exists!\n");
            return;
        }
    }
    Task new_task;
    new_task.task = task;
    new_task.priority = priority;
    new_task.pid = getpid();
    tasks[num_tasks++] = new_task;
}

// Function to delete a task
void delete_task(Task *tasks, int num_tasks, int pid) {
    int i;
    for (i = 0; i < num_tasks; i++) {
        if (tasks[i].pid == pid) {
            printf("Task %d deleted!\n", i);
            for (int j = i; j < num_tasks - 1; j++) {
                tasks[j] = tasks[j + 1];
            }
            num_tasks--;
            return;
        }
    }
    printf("Task not found!\n");
}

// Function to set task priority
void set_task_priority(Task *tasks, int num_tasks, int pid, int priority) {
    int i;
    for (i = 0; i < num_tasks; i++) {
        if (tasks[i].pid == pid) {
            tasks[i].priority = priority;
            return;
        }
    }
    printf("Task not found!\n");
}