//GPT-4o-mini DATASET v1.0 Category: Wi-Fi Signal Strength Analyzer ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// A humble struct to house the sacred information of Wi-Fi networks
typedef struct {
    char name[50];  // The name of the Wi-Fi realm
    int strength;   // The strength of the Wi-Fi signal in decibels
} WiFiRealm;

// A sacred scroll to record findings of Wi-Fi signal strengths
void recordFindings(WiFiRealm *realms, int count) {
    FILE *scroll = fopen("wifi_signal_strength.txt", "w");
    if (scroll == NULL) {
        printf("Alas! The scroll could not be opened. Thy data shall be lost.\n");
        return;
    }

    fprintf(scroll, "Wi-Fi Signal Strengths:\n");
    fprintf(scroll, "-----------------------\n");

    for (int i = 0; i < count; i++) {
        fprintf(scroll, "Realm: %s - Strength: %d dBm\n", realms[i].name, realms[i].strength);
    }

    fclose(scroll);
    printf("Thy data hath been inscribed upon the scroll for all eternity!\n");
}

// A mysterious method to harvest signal strength from the realm
int gatherSignalStrength(const char *realmName) {
    // For the purpose of this medieval tale, we'll use random values
    // as if a wizard were casting a spell to ascertain the strength.
    return rand() % 100 - 50; // Random signal strength between -50 and -150 dBm
}

// The noble quest to discover and list all available Wi-Fi realms
void discoverWiFiRealms(WiFiRealm *realms, int *count) {
    printf("Hear ye, hear ye! The following Wi-Fi realms hath been discovered:\n");
    
    const char *knownRealms[] = {
        "CastleNet", "DungeonWiFi", "DragonFlyNet", "KnightBridge",
        "WizardWeb", "ElvenConnection", "SquireSpot", "RoyalRouter"
    };

    int knownCount = sizeof(knownRealms) / sizeof(knownRealms[0]);
    *count = 0;

    for (int i = 0; i < knownCount; i++) {
        strcpy(realms[*count].name, knownRealms[i]);
        realms[*count].strength = gatherSignalStrength(knownRealms[i]);
        printf("Realm: %s - Strength: %d dBm\n", realms[*count].name, realms[*count].strength);
        (*count)++;
    }
}

// The kingdom's main quest starts here
int main() {
    srand((unsigned int)time(NULL)); // Seed the random number generator
    
    printf("Welcome, brave adventurer, to the Wi-Fi Signal Strength Analyzer!\n\n");

    WiFiRealm realms[50];  // A list to hold up to 50 realms
    int realmCount = 0;     // A count of realms discovered

    discoverWiFiRealms(realms, &realmCount);   // Discover realms
    recordFindings(realms, realmCount);         // Inscribe findings on scroll

    printf("The quest is complete! Return to thine kingdom!\n");
    return 0; // The tale concludes
}