//Falcon-180B DATASET v1.0 Category: Medical Store Management System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of items that can be stored in the inventory
#define MAX_INVENTORY_SIZE 100

// Define the structure for an item in the inventory
typedef struct {
    char name[50];
    int quantity;
    float price;
} Item;

// Declare the global inventory array
Item inventory[MAX_INVENTORY_SIZE];

// Declare the number of items currently in the inventory
int numItems = 0;

// Function to add an item to the inventory
void addItem(Item* newItem) {
    // Check if there is space in the inventory
    if (numItems >= MAX_INVENTORY_SIZE) {
        printf("Sorry, inventory is full!\n");
        return;
    }

    // Copy the new item to the inventory
    inventory[numItems] = *newItem;
    numItems++;
}

// Function to remove an item from the inventory
void removeItem(int index) {
    // Check if the index is valid
    if (index < 0 || index >= numItems) {
        printf("Invalid item index!\n");
        return;
    }

    // Remove the item from the inventory
    numItems--;

    // Shift the remaining items to fill the gap
    for (int i = index; i < numItems; i++) {
        inventory[i] = inventory[i+1];
    }
}

// Function to display the current inventory
void displayInventory() {
    printf("Current inventory:\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s - %d units - $%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    // Initialize the inventory with some items
    addItem(&(Item){.name = "Aspirin",.quantity = 100,.price = 0.10 });
    addItem(&(Item){.name = "Ibuprofen",.quantity = 50,.price = 0.25 });
    addItem(&(Item){.name = "Paracetamol",.quantity = 75,.price = 0.15 });

    // Display the initial inventory
    displayInventory();

    // Simulate some sales
    removeItem(0);
    removeItem(2);

    // Display the updated inventory
    displayInventory();

    return 0;
}