//Gemma-7B DATASET v1.0 Category: Banking Record System ; Style: futuristic
#include <stdio.h>
#include <string.h>

#define MAX_CUSTOMERS 100

typedef struct customer {
    char name[50];
    int account_number;
    double balance;
} customer;

customer customers[MAX_CUSTOMERS];

void deposit(int account_number, double amount)
{
    for (int i = 0; i < MAX_CUSTOMERS; i++)
    {
        if (customers[i].account_number == account_number)
        {
            customers[i].balance += amount;
            printf("Deposit successful!\n");
            return;
        }
    }

    printf("Account number not found.\n");
}

void withdraw(int account_number, double amount)
{
    for (int i = 0; i < MAX_CUSTOMERS; i++)
    {
        if (customers[i].account_number == account_number)
        {
            if (amount <= customers[i].balance)
            {
                customers[i].balance -= amount;
                printf("Withdrawal successful!\n");
                return;
            }
            else
            {
                printf("Insufficient funds.\n");
                return;
            }
        }
    }

    printf("Account number not found.\n");
}

void transfer(int from_account_number, int to_account_number, double amount)
{
    for (int i = 0; i < MAX_CUSTOMERS; i++)
    {
        if (customers[i].account_number == from_account_number)
        {
            if (amount <= customers[i].balance)
            {
                for (int j = 0; j < MAX_CUSTOMERS; j++)
                {
                    if (customers[j].account_number == to_account_number)
                    {
                        customers[j].balance += amount;
                        customers[i].balance -= amount;
                        printf("Transfer successful!\n");
                        return;
                    }
                }

                printf("Account number not found.\n");
            }
            else
            {
                printf("Insufficient funds.\n");
                return;
            }
        }
    }

    printf("Account number not found.\n");
}

int main()
{
    deposit(123, 100);
    withdraw(123, 50);
    transfer(123, 456, 20);

    for (int i = 0; i < MAX_CUSTOMERS; i++)
    {
        printf("Name: %s, Account Number: %d, Balance: %.2lf\n", customers[i].name, customers[i].account_number, customers[i].balance);
    }

    return 0;
}