//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define KEY_LENGTH 16
#define BLOCK_SIZE 16
#define ROUNDS 10

void generate_key(unsigned char key[KEY_LENGTH]) {
    srand(time(NULL));
    for (int i = 0; i < KEY_LENGTH; i++) {
        key[i] = rand() % 256;
    }
}

void encrypt(unsigned char key[KEY_LENGTH], unsigned char plaintext[BLOCK_SIZE], unsigned char ciphertext[BLOCK_SIZE]) {
    int j = 0;
    for (int i = 0; i < BLOCK_SIZE; i++) {
        ciphertext[i] = plaintext[i] ^ key[j];
        j = (j + 1) % KEY_LENGTH;
    }
}

void decrypt(unsigned char key[KEY_LENGTH], unsigned char ciphertext[BLOCK_SIZE], unsigned char plaintext[BLOCK_SIZE]) {
    int j = 0;
    for (int i = 0; i < BLOCK_SIZE; i++) {
        plaintext[i] = ciphertext[i] ^ key[j];
        j = (j + 1) % KEY_LENGTH;
    }
}

int main() {
    unsigned char key[KEY_LENGTH];
    generate_key(key);

    unsigned char plaintext[BLOCK_SIZE] = "Hello, world!";
    unsigned char ciphertext[BLOCK_SIZE];

    printf("Plaintext: %s\n", plaintext);
    encrypt(key, plaintext, ciphertext);
    printf("Ciphertext: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", ciphertext[i]);
    }
    printf("\n");

    unsigned char plaintext2[BLOCK_SIZE];
    decrypt(key, ciphertext, plaintext2);
    printf("Decrypted plaintext: %s\n", plaintext2);

    return 0;
}