//GEMINI-pro DATASET v1.0 Category: Automated Fortune Teller ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <time.h> // For rand(), srand()
#include <string.h> // For strlen(), strcpy()

#define CARDS 52
#define SUITS 4
#define RANKS 13
#define FORTUNES 10

char suits[SUITS][10] = {"Spades", "Hearts", "Diamonds", "Clubs"};
char ranks[RANKS][10] = {"Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Jack", "Queen", "King", "Ace"};
char fortunes[FORTUNES][100] = {
    "You will find true love.",
    "You will win a lot of money.",
    "You will have a successful career.",
    "You will travel the world.",
    "You will live a long and happy life.",
    "You will be a great leader.",
    "You will make a difference in the world.",
    "You will be a great artist.",
    "You will be a famous scientist.",
    "You will be a successful entrepreneur.",
};

int main() {
 
 srand(time(NULL)); // Seed the random number generator with the current time
 int deck[CARDS]; // The deck of cards - 0 to 51

 for (int i = 0; i < CARDS; i++) {
   deck[i] = i; // Initialize the deck with all cards
 }

 for (int i = 0; i < CARDS; i++) {
   int r = rand() % (CARDS - i); // Generate a random index from 0 to CARDS - i - 1
   int temp = deck[i]; // Swap the card at index i with the card at index r
   deck[i] = deck[r];
   deck[r] = temp;
 }

 int card = deck[rand() % CARDS]; // Draw a random card from the deck
 int suit = card / RANKS; // Get the suit of the card
 int rank = card % RANKS; // Get the rank of the card

 printf("Your card is the %s of %s.\n", ranks[rank], suits[suit]);

 int fortuneIndex = rand() % FORTUNES; // Generate a random fortune index

 printf("Your fortune is:\n%s\n", fortunes[fortuneIndex]);

 return 0;
}