//GEMINI-pro DATASET v1.0 Category: Basic Unix-like Shell ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>

// Maximum number of arguments in a command
#define MAX_ARGS 10

// Maximum length of a command
#define MAX_COMMAND_LENGTH 100

// Maximum number of commands in a history
#define MAX_HISTORY 10

// History of commands
char *history[MAX_HISTORY];

// Current index in the history
int history_index = 0;

// Prompt string
char *prompt = "myshell> ";

// Function to print the prompt
void print_prompt() {
  printf("%s ", prompt);
}

// Function to read a line from the user
char *read_line() {
  char *line = NULL;
  size_t len = 0;
  getline(&line, &len, stdin);
  return line;
}

// Function to parse a command line into arguments
char **parse_args(char *line) {
  char *args[MAX_ARGS];
  char *arg = strtok(line, " ");
  int i = 0;
  while (arg && i < MAX_ARGS) {
    args[i++] = arg;
    arg = strtok(NULL, " ");
  }
  args[i] = NULL;
  return args;
}

// Function to execute a command
int execute_command(char **args) {
  pid_t pid = fork();
  if (pid == 0) {
    // Child process
    execvp(args[0], args);
    perror("execvp");
    exit(1);
  } else if (pid > 0) {
    // Parent process
    int status;
    waitpid(pid, &status, 0);
    return status;
  } else {
    // Fork failed
    perror("fork");
    return 1;
  }
}

// Function to add a command to the history
void add_to_history(char *command) {
  if (history_index < MAX_HISTORY) {
    history[history_index++] = strdup(command);
  } else {
    // History is full, so overwrite the oldest command
    free(history[0]);
    for (int i = 1; i < MAX_HISTORY; i++) {
      history[i - 1] = history[i];
    }
    history[MAX_HISTORY - 1] = strdup(command);
  }
}

// Function to print the history
void print_history() {
  for (int i = 0; i < history_index; i++) {
    printf("%d: %s\n", i + 1, history[i]);
  }
}

// Main loop
int main() {
  while (1) {
    print_prompt();
    char *line = read_line();
    if (line == NULL) {
      // EOF
      break;
    }
    char **args = parse_args(line);
    if (args[0] == NULL) {
      // Empty command
      continue;
    }
    if (strcmp(args[0], "exit") == 0) {
      // Exit command
      break;
    } else if (strcmp(args[0], "history") == 0) {
      // History command
      print_history();
    } else {
      // Execute command
      add_to_history(line);
      execute_command(args);
    }
    free(line);
    free(args);
  }
  return 0;
}