//Falcon2-11B DATASET v1.0 Category: Breakout Game Clone ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <GL/glut.h>

void display(void);
void keyboard(unsigned char key, int x, int y);
void reshape(int w, int h);
void idle(void);

int width, height, x, y;
int speed, angle;
int score = 0;

int main(int argc, char** argv)
{
    srand(time(NULL));
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
    glutInitWindowSize(500, 500);
    glutInitWindowPosition(100, 100);
    glutCreateWindow("Breakout");
    glutDisplayFunc(display);
    glutIdleFunc(idle);
    glutReshapeFunc(reshape);
    glutKeyboardFunc(keyboard);
    glutMainLoop();
    return 0;
}

void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
    gluLookAt(0, 0, 5, 0, 0, 0, 0, 1, 0);
    glRotatef(angle, 0, 0, 1);
    glTranslatef(x, y, 0);
    glColor3f(0, 1, 0);
    glBegin(GL_QUADS);
    glVertex2f(0, 0);
    glVertex2f(width, 0);
    glVertex2f(width, height);
    glVertex2f(0, height);
    glEnd();
    glColor3f(1, 1, 1);
    glBegin(GL_QUADS);
    glVertex2f(0, 0);
    glVertex2f(0, height);
    glVertex2f(width, height);
    glVertex2f(width, 0);
    glEnd();
    glColor3f(0, 0, 1);
    glBegin(GL_QUADS);
    glVertex2f(0, 0);
    glVertex2f(0, height);
    glVertex2f(width, height);
    glVertex2f(width, 0);
    glEnd();
    glColor3f(1, 1, 0);
    glBegin(GL_QUADS);
    glVertex2f(0, 0);
    glVertex2f(width, 0);
    glVertex2f(width, height);
    glVertex2f(0, height);
    glEnd();
    glColor3f(0, 1, 0);
    glBegin(GL_QUADS);
    glVertex2f(0, 0);
    glVertex2f(0, height);
    glVertex2f(width, height);
    glVertex2f(width, 0);
    glEnd();
    glFlush();
    glutSwapBuffers();
}

void keyboard(unsigned char key, int x, int y)
{
    if (key == 27)
        exit(0);
    switch (key)
    {
        case 'w':
            y += speed;
            break;
        case's':
            y -= speed;
            break;
        case 'a':
            angle += 10;
            break;
        case 'd':
            angle -= 10;
            break;
    }
}

void reshape(int w, int h)
{
    width = w;
    height = h;
}

void idle(void)
{
    if (score == 10)
    {
        printf("Congratulations! You won!\n");
        exit(0);
    }
    else if (score == 0)
    {
        printf("Game over!\n");
        exit(0);
    }
    score += 1;
    glutPostRedisplay();
}