//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define WIDTH 32
#define HEIGHT 16

void drawPixel(char canvas[HEIGHT][WIDTH], int x, int y, char pixel) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        canvas[y][x] = pixel;
    }
}

void clearCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas[y][x] = ' ';
        }
    }
}

void displayCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            putchar(canvas[y][x]);
        }
        putchar('\n');
    }
}

void drawCharacter(char canvas[HEIGHT][WIDTH], int startX, int startY) {
    char star = '*';
    // Draw a simple character 'A'
    drawPixel(canvas, startX + 1, startY, star);
    drawPixel(canvas, startX + 2, startY, star);
    drawPixel(canvas, startX, startY + 1, star);
    drawPixel(canvas, startX + 3, startY + 1, star);
    drawPixel(canvas, startX + 1, startY + 2, star);
    drawPixel(canvas, startX + 2, startY + 2, star);
    drawPixel(canvas, startX + 1, startY + 3, star);
}

void drawHeart(char canvas[HEIGHT][WIDTH], int startX, int startY) {
    char heart = '@';
    // Draw a simple heart shape
    drawPixel(canvas, startX + 1, startY, heart);
    drawPixel(canvas, startX + 0, startY + 1, heart);
    drawPixel(canvas, startX + 1, startY + 1, heart);
    drawPixel(canvas, startX + 2, startY + 1, heart);
    drawPixel(canvas, startX + 3, startY + 1, heart);
    drawPixel(canvas, startX + 0, startY + 2, heart);
    drawPixel(canvas, startX + 1, startY + 2, heart);
    drawPixel(canvas, startX + 2, startY + 2, heart);
    drawPixel(canvas, startX + 3, startY + 2, heart);
    drawPixel(canvas, startX + 1, startY + 3, heart);
    drawPixel(canvas, startX + 2, startY + 3, heart);
}

void drawBorder(char canvas[HEIGHT][WIDTH]) {
    for (int x = 0; x < WIDTH; x++) {
        drawPixel(canvas, x, 0, '#');
        drawPixel(canvas, x, HEIGHT - 1, '#');
    }
    for (int y = 0; y < HEIGHT; y++) {
        drawPixel(canvas, 0, y, '#');
        drawPixel(canvas, WIDTH - 1, y, '#');
    }
}

int main() {
    char canvas[HEIGHT][WIDTH];

    clearCanvas(canvas);
    drawBorder(canvas);
    drawCharacter(canvas, 5, 3);
    drawHeart(canvas, 12, 5);
    
    printf("\033[H\033[J"); // Clear the console
    displayCanvas(canvas);

    return 0;
}