//MISTRAL-7B DATASET v1.0 Category: Movie Rating System ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

typedef struct Movie {
    char title[100];
    float rating;
    int year;
} Movie;

void print_movie(Movie movie) {
    printf("Title: %s\n", movie.title);
    printf("Rating: %.2f\n", movie.rating);
    printf("Year: %d\n", movie.year);
}

int random_rating() {
    return rand() % 10 + 1;
}

void generate_movie(Movie* movie) {
    strcpy(movie->title, "Movie Title: The Curious Case of...");
    movie->year = rand() % 100 + 2000;
    movie->rating = (float) random_rating() / 10.0;
}

int main(void) {
    srand(time(NULL));

    Movie movie;
    generate_movie(&movie);

    printf("A new movie has appeared!\n");
    print_movie(movie);

    // A group of curious movie critics comes together
    int critics = 5;
    Movie critics_movies[critics];

    for (int i = 0; i < critics; i++) {
        Movie* critic_movie = &critics_movies[i];
        generate_movie(critic_movie);

        printf("\n--- Critic %d's Review ---\n", i + 1);
        print_movie(*critic_movie);

        // Critic watches the movie and rates it
        printf("Critic %d: I've watched it and...\n", i + 1);
        if (movie.rating > critic_movie->rating) {
            printf("...I liked it more! Its new rating is %.2f.\n", movie.rating);
            movie.rating += 0.1;
        } else {
            printf("...I liked it less! Its new rating is %.2f.\n", critic_movie->rating);
            movie.rating -= 0.1;
        }
        print_movie(movie);
        printf("\n");
    }

    printf("After all the reviews, the movie's final rating is: %.2f\n", movie.rating);

    return 0;
}