//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: genious
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// Mutex to synchronize access to shared data
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

// Condition variable to signal threads waiting for work
pthread_cond_t condition_variable = PTHREAD_COND_INITIALIZER;

// Number of threads
#define NUM_THREADS 5

// Shared data between threads
int shared_data = 0;

// Function to be executed by each thread
void *count_to_ten(void *arg) {
    int id = *(int *) arg;
    printf("Thread %d started\n", id);

    // Lock the mutex to access shared data
    pthread_mutex_lock(&mutex);

    // Increment shared data and print its value
    shared_data++;
    printf("Shared data is now %d\n", shared_data);

    // Unlock the mutex
    pthread_mutex_unlock(&mutex);

    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    int thread_ids[NUM_THREADS];

    // Create threads
    for (int i = 0; i < NUM_THREADS; i++) {
        thread_ids[i] = i;
        pthread_create(&threads[i], NULL, count_to_ten, &thread_ids[i]);
    }

    // Wait for all threads to finish
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("All threads have finished\n");
    return 0;
}