//LLAMA2-13B DATASET v1.0 Category: Matrix operations ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROWS 100
#define MAX_COLS 100

typedef struct {
    int rows;
    int cols;
    int **matrix;
} matrix_t;

void init_matrix(matrix_t *m) {
    m->rows = 0;
    m->cols = 0;
    m->matrix = NULL;
}

void destroy_matrix(matrix_t *m) {
    if (m->matrix != NULL) {
        free(m->matrix);
        m->matrix = NULL;
    }
}

void add_element(matrix_t *m, int row, int col, int value) {
    if (m->rows < MAX_ROWS && m->cols < MAX_COLS) {
        if (row >= m->rows || col >= m->cols) {
            printf("Invalid row or column index\n");
            return;
        }
        m->matrix[row][col] = value;
    } else {
        printf("Matrix is full, cannot add element\n");
    }
}

int get_element(matrix_t *m, int row, int col) {
    if (m->rows < MAX_ROWS && m->cols < MAX_COLS) {
        if (row >= m->rows || col >= m->cols) {
            printf("Invalid row or column index\n");
            return -1;
        }
        return m->matrix[row][col];
    } else {
        printf("Matrix is empty, cannot get element\n");
        return -1;
    }
}

void print_matrix(matrix_t *m) {
    int i, j;
    for (i = 0; i < m->rows; i++) {
        for (j = 0; j < m->cols; j++) {
            printf("%d ", m->matrix[i][j]);
        }
        printf("\n");
    }
}

int main() {
    matrix_t m;
    init_matrix(&m);

    // Add elements
    add_element(&m, 1, 2, 3);
    add_element(&m, 2, 3, 4);
    add_element(&m, 3, 1, 5);
    add_element(&m, 4, 2, 6);

    // Get elements
    int element1 = get_element(&m, 1, 2);
    int element2 = get_element(&m, 2, 3);
    int element3 = get_element(&m, 3, 1);
    int element4 = get_element(&m, 4, 2);

    // Print matrix
    print_matrix(&m);

    // Check if matrix is full
    if (get_element(&m, 4, 3) != -1) {
        printf("Matrix is not full\n");
    } else {
        printf("Matrix is full\n");
    }

    // Check if matrix is empty
    if (get_element(&m, 1, 1) == -1) {
        printf("Matrix is empty\n");
    } else {
        printf("Matrix is not empty\n");
    }

    destroy_matrix(&m);

    return 0;
}