//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void add_item(char *name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit reached.\n");
}

void print_items() {
    for (int i = 0; items[i].name[0] != '\0'; i++) {
        printf("%s: %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
    }
}

void calculate_total() {
    float total = 0;
    for (int i = 0; items[i].name[0] != '\0'; i++) {
        total += items[i].quantity * items[i].price;
    }

    printf("Total: $%.2f\n", total);
}

int main() {
    add_item("Coffee", 5, 2.50);
    add_item("Tea", 3, 1.25);
    add_item("Juice", 2, 1.50);

    print_items();

    calculate_total();

    return 0;
}