//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

struct Garden {
    char name[50];
    int flowers; // Number of flowers in the garden
    int romanceValue; // Romance value of the flowers
};

// Function to compare two gardens based on the ratio of romance value to flowers
int compareGardens(const void *a, const void *b) {
    struct Garden *gardenA = (struct Garden *)a;
    struct Garden *gardenB = (struct Garden *)b;
    double ratioA = (double)gardenA->romanceValue / gardenA->flowers;
    double ratioB = (double)gardenB->romanceValue / gardenB->flowers;
    
    if (ratioA < ratioB) return 1; // Larger ratio is better
    if (ratioA > ratioB) return -1;
    return 0;
}

void collectFlowers(struct Garden gardens[], int numGardens, int maxFlowers) {
    int totalRomance = 0;
    int totalFlowersCollected = 0;

    // Sort gardens based on the ratio of romance value to flowers
    qsort(gardens, numGardens, sizeof(struct Garden), compareGardens);

    printf("Romeo and Juliet venture through the gardens...\n");
    for (int i = 0; i < numGardens; i++) {
        if (totalFlowersCollected < maxFlowers) {
            int flowersToCollect = gardens[i].flowers;

            // Check if they can collect all flowers from this garden
            if (totalFlowersCollected + flowersToCollect <= maxFlowers) {
                totalFlowersCollected += flowersToCollect;
                totalRomance += gardens[i].romanceValue;
                printf("In the %s, they collected all %d flowers, gaining %d romance points.\n",
                       gardens[i].name, flowersToCollect, gardens[i].romanceValue);
            } else {
                // Collect only as many as they can
                int flowersTheyCanCollect = maxFlowers - totalFlowersCollected;
                totalFlowersCollected += flowersTheyCanCollect;
                totalRomance += (gardens[i].romanceValue * flowersTheyCanCollect) / gardens[i].flowers;
                printf("In the %s, they collected %d flowers, gaining %d romance points.\n",
                       gardens[i].name, flowersTheyCanCollect,
                       (gardens[i].romanceValue * flowersTheyCanCollect) / gardens[i].flowers);
            }
        }
    }

    printf("Total flowers collected: %d\n", totalFlowersCollected);
    printf("Total romance value attained: %d\n", totalRomance);
}

int main() {
    struct Garden gardens[] = {
        {"Rose Garden", 50, 100},
        {"Tulip Grove", 40, 80},
        {"Daisy Field", 30, 60},
        {"Sunflower Patch", 20, 50},
        {"Lily Lagoon", 10, 30}
    };
    
    int numGardens = sizeof(gardens) / sizeof(gardens[0]);
    int maxFlowersToCollect = 100;

    printf("Romeo and Juliet have embarked on their colorful adventure!\n");
    collectFlowers(gardens, numGardens, maxFlowersToCollect);

    return 0;
}