//MISTRAL-7B DATASET v1.0 Category: Database simulation ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_SIM_OBJ 100
#define MAX_SIM_RELATION 10

typedef struct {
    char name[50];
    int id;
    float x, y, z;
    char color[10];
} SimObject;

typedef struct {
    int idObject1, idObject2;
    char relation[15];
} SimRelation;

SimObject objects[MAX_SIM_OBJ];
SimRelation relations[MAX_SIM_RELATION];
int numObjects = 0, numRelations = 0;

void createObject(char *name, int id, float x, float y, float z, char *color) {
    if (numObjects >= MAX_SIM_OBJ) {
        printf("Error: Maximum number of objects reached.\n");
        return;
    }

    strcpy(objects[numObjects].name, name);
    objects[numObjects].id = id;
    objects[numObjects].x = x;
    objects[numObjects].y = y;
    objects[numObjects].z = z;
    strcpy(objects[numObjects].color, color);

    numObjects++;
}

void createRelation(int idObj1, int idObj2, char *relation) {
    if (numRelations >= MAX_SIM_RELATION) {
        printf("Error: Maximum number of relations reached.\n");
        return;
    }

    relations[numRelations].idObject1 = idObj1;
    relations[numRelations].idObject2 = idObj2;
    strcpy(relations[numRelations].relation, relation);

    numRelations++;
}

void printObjects() {
    printf("\nObjects:\n");

    for (int i = 0; i < numObjects; i++) {
        printf("\nID: %d\nName: %s\nPosition: (%f, %f, %f)\nColor: %s", objects[i].id, objects[i].name, objects[i].x, objects[i].y, objects[i].z, objects[i].color);
    }
}

void printRelations() {
    printf("\nRelations:\n");

    for (int i = 0; i < numRelations; i++) {
        printf("\nID Object 1: %d\nID Object 2: %d\nRelation: %s", relations[i].idObject1, relations[i].idObject2, relations[i].relation);
    }
}

void simulate() {
    srand(time(NULL));

    createObject("Cube 1", 1, 0, 0, 0, "Red");
    createObject("Cube 2", 2, 5, 5, 5, "Blue");
    createObject("Cube 3", 3, 10, 10, 10, "Green");
    createRelation(1, 2, "Connects with");
    createRelation(2, 3, "Attached to");

    printObjects();
    printRelations();

    for (int i = 0; i < numObjects; i++) {
        objects[i].x += rand() % 10 - 5;
        objects[i].y += rand() % 10 - 5;
        objects[i].z += rand() % 10 - 5;
    }

    printf("\nAfter simulating for some time:\n");
    printObjects();
    printRelations();
}

int main() {
    simulate();
    return 0;
}