//MISTRAL-7B DATASET v1.0 Category: Banking Record System ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_ACCOUNTS 100

typedef struct {
    int account_number;
    char name[50];
    float balance;
} Account;

Account accounts[MAX_ACCOUNTS];
int num_accounts = 0;

bool account_exists(int account_number) {
    for (int i = 0; i < num_accounts; i++) {
        if (accounts[i].account_number == account_number) {
            return true;
        }
    }
    return false;
}

void create_account(int account_number, const char *name, float initial_balance) {
    if (account_exists(account_number)) {
        printf("Account already exists.\n");
        return;
    }

    strcpy(accounts[num_accounts].name, name);
    accounts[num_accounts].account_number = account_number;
    accounts[num_accounts].balance = initial_balance;
    num_accounts++;
}

void deposit(int account_number, float amount) {
    if (!account_exists(account_number)) {
        printf("Account not found.\n");
        return;
    }

    accounts[find_account(account_number)].balance += amount;
}

void withdraw(int account_number, float amount) {
    if (!account_exists(account_number) || accounts[find_account(account_number)].balance < amount) {
        printf("Insufficient funds or account not found.\n");
        return;
    }

    accounts[find_account(account_number)].balance -= amount;
}

int find_account(int account_number) {
    for (int i = 0; i < num_accounts; i++) {
        if (accounts[i].account_number == account_number) {
            return i;
        }
    }

    // Should not reach here
    printf("Error: Account not found.\n");
    exit(1);
}

int main() {
    create_account(1, "John Doe", 500.0);
    create_account(2, "Jane Doe", 1000.0);

    deposit(1, 200.0);
    withdraw(2, 500.0);

    for (int i = 0; i < num_accounts; i++) {
        printf("Account %d: %s, Balance: %.2f\n", accounts[i].account_number, accounts[i].name, accounts[i].balance);
    }

    return 0;
}