//GEMINI-pro DATASET v1.0 Category: Threading Library Implementation ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// The two threads will share this data structure
typedef struct {
    int love_level; // Their love for each other is a number
    char *name; // Their names are just strings
} Couple;

// This function will be executed by the first thread
void *first_thread(void *arg) {
    // Get the couple data structure from the argument
    Couple *couple = (Couple *)arg;

    // Increase their love level
    couple->love_level++;

    // Print a romantic message
    printf("My dearest %s, my love for you has grown by 1! It is now %d.\n",
        couple->name, couple->love_level);

    return NULL;
}

// This function will be executed by the second thread
void *second_thread(void *arg) {
    // Get the couple data structure from the argument
    Couple *couple = (Couple *)arg;

    // Sleep for a while (to simulate the other person taking time to reciprocate)
    // Thread 2 needs to think more about love :D
    sleep(1);

    // Increase their love level
    couple->love_level++;

    // Print a romantic message
    printf("Oh my darling %s, I love you even more! It is now %d.\n",
        couple->name, couple->love_level);

    return NULL;
}

int main() {
    // Initialize the couple data structure
    Couple couple = {
        .love_level = 0, // Their love starts at 0
        .name = "Romeo and Juliet", // Their names are Romeo and Juliet
    };

    // Create the two threads
    pthread_t t1, t2;

    // Create the first thread
    pthread_create(&t1, NULL, first_thread, &couple);

    // Create the second thread
    pthread_create(&t2, NULL, second_thread, &couple);

    // Wait for the threads to finish
    pthread_join(t1, NULL);
    pthread_join(t2, NULL);

    // Print a final romantic message
    printf("Their love has grown to %d! They lived happily ever after.\n",
        couple.love_level);

    return 0;
}