//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CONTACTS 100

typedef struct {
    char name[50];
    char phone[15];
} contact;

void add_contact(contact* book, int count, char* name, char* phone) {
    if (count >= MAX_CONTACTS) {
        printf("Sorry, phone book is full.\n");
        return;
    }

    strcpy(book[count].name, name);
    strcpy(book[count].phone, phone);
    count++;
}

void search_contact(contact* book, int count, char* name) {
    int i;

    for (i = 0; i < count; i++) {
        if (strcmp(book[i].name, name) == 0) {
            printf("Name: %s\nPhone: %s\n", book[i].name, book[i].phone);
            return;
        }
    }

    printf("Contact not found.\n");
}

void delete_contact(contact* book, int* count, char* name) {
    int i;

    for (i = 0; i < *count; i++) {
        if (strcmp(book[i].name, name) == 0) {
            memmove(&book[i], &book[i + 1], (*count - i - 1) * sizeof(contact));
            (*count)--;
            return;
        }
    }

    printf("Contact not found.\n");
}

int main() {
    contact book[MAX_CONTACTS];
    int count = 0;

    add_contact(book, count, "John Doe", "123-4567");
    add_contact(book, count, "Jane Smith", "987-6543");

    search_contact(book, count, "John Doe");

    delete_contact(book, &count, "Jane Smith");

    return 0;
}