//Falcon2-11B DATASET v1.0 Category: Alien Language Translator ; Style: scalable
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_WORDS 100
#define MAX_LENGTH 20

// Struct to hold a word and its translation
typedef struct {
    char word[MAX_LENGTH];
    char translation[MAX_LENGTH];
} Word;

// Global dictionary of alien words and their translations
Word words[MAX_WORDS];

// Function to add a word to the dictionary
void addWord(char* word, char* translation) {
    if (word[0] == '\0' || translation[0] == '\0')
        return;

    int i;
    for (i = 0; i < MAX_WORDS; i++) {
        if (strcmp(words[i].word, word) == 0) {
            strcpy(words[i].translation, translation);
            return;
        }
    }

    if (MAX_WORDS == i)
        return;

    strcpy(words[i].word, word);
    strcpy(words[i].translation, translation);
}

// Function to translate an alien word into English
char* translateWord(char* word) {
    int i;
    for (i = 0; i < MAX_WORDS; i++) {
        if (strcmp(words[i].word, word) == 0)
            return words[i].translation;
    }

    return NULL;
}

int main() {
    char message[100];
    char* translated = NULL;

    // Add some alien words to the dictionary
    addWord("bleep", "bloop");
    addWord("blop", "blip");
    addWord("zap", "zit");

    // Get the user's message
    printf("Enter an alien message: ");
    fgets(message, sizeof(message), stdin);

    // Remove the newline character from the end of the message
    message[strcspn(message, "\n")] = '\0';

    // Translate the message
    translated = translateWord(message);
    if (translated!= NULL)
        printf("Translation: %s\n", translated);
    else
        printf("Translation not found.\n");

    return 0;
}