//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Data structures for representing 2D points and vectors
typedef struct {
    double x, y;
} point_t;

typedef struct {
    double dx, dy;
} vector_t;

// Function to create a point from its coordinates
point_t point_create(double x, double y) {
    point_t p;
    p.x = x;
    p.y = y;
    return p;
}

// Function to create a vector from its components
vector_t vector_create(double dx, double dy) {
    vector_t v;
    v.dx = dx;
    v.dy = dy;
    return v;
}

// Function to compute the dot product of two vectors
double vector_dot(vector_t v1, vector_t v2) {
    return v1.dx * v2.dx + v1.dy * v2.dy;
}

// Function to compute the cross product of two vectors
double vector_cross(vector_t v1, vector_t v2) {
    return v1.dx * v2.dy - v1.dy * v2.dx;
}

// Function to compute the norm of a vector
double vector_norm(vector_t v) {
    return sqrt(vector_dot(v, v));
}

// Function to compute the distance between two points
double point_distance(point_t p1, point_t p2) {
    vector_t v = vector_create(p2.x - p1.x, p2.y - p1.y);
    return vector_norm(v);
}

// Function to compute the area of a triangle formed by three points
double triangle_area(point_t p1, point_t p2, point_t p3) {
    vector_t v1 = vector_create(p2.x - p1.x, p2.y - p1.y);
    vector_t v2 = vector_create(p3.x - p1.x, p3.y - p1.y);
    return 0.5 * fabs(vector_cross(v1, v2));
}

// Function to check if a point is inside a triangle
int point_in_triangle(point_t p, point_t p1, point_t p2, point_t p3) {
    double a1 = triangle_area(p, p2, p3);
    double a2 = triangle_area(p, p1, p3);
    double a3 = triangle_area(p, p1, p2);
    double a = triangle_area(p1, p2, p3);
    return fabs(a1 + a2 + a3 - a) < 1e-6;
}

int main() {
    // Define three points to form a triangle
    point_t p1 = point_create(0, 0);
    point_t p2 = point_create(1, 0);
    point_t p3 = point_create(0, 1);

    // Define a point to check if it is inside the triangle
    point_t p = point_create(0.5, 0.5);

    // Check if the point is inside the triangle
    int is_inside = point_in_triangle(p, p1, p2, p3);

    // Print the result
    printf("The point (%lf, %lf) is %s the triangle.\n", p.x, p.y, is_inside ? "inside" : "outside");

    return 0;
}