//GEMINI-pro DATASET v1.0 Category: Database querying ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Define the database file name
#define DB_FILE "mydb.db"

// Define the SQL query
#define SQL_QUERY "SELECT * FROM users WHERE name = ? AND age = ?"

int main() {
    // Open the database
    sqlite3 *db;
    if (sqlite3_open(DB_FILE, &db) != SQLITE_OK) {
        fprintf(stderr, "Error opening database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Prepare the SQL statement
    sqlite3_stmt *stmt;
    if (sqlite3_prepare_v2(db, SQL_QUERY, -1, &stmt, NULL) != SQLITE_OK) {
        fprintf(stderr, "Error preparing statement: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Bind the parameters
    if (sqlite3_bind_text(stmt, 1, "John Doe", -1, SQLITE_STATIC) != SQLITE_OK) {
        fprintf(stderr, "Error binding parameter: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }
    if (sqlite3_bind_int(stmt, 2, 30) != SQLITE_OK) {
        fprintf(stderr, "Error binding parameter: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Execute the query
    int rc = sqlite3_step(stmt);
    if (rc != SQLITE_ROW) {
        if (rc == SQLITE_DONE) {
            printf("No results found.\n");
        } else {
            fprintf(stderr, "Error executing statement: %s\n", sqlite3_errmsg(db));
            sqlite3_close(db);
            return 1;
        }
    } else {
        // Print the results
        printf("ID: %d\n", sqlite3_column_int(stmt, 0));
        printf("Name: %s\n", sqlite3_column_text(stmt, 1));
        printf("Age: %d\n", sqlite3_column_int(stmt, 2));
    }

    // Finalize the statement
    sqlite3_finalize(stmt);

    // Close the database
    sqlite3_close(db);

    return 0;
}