//GEMINI-pro DATASET v1.0 Category: Chat server ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080

// Define the chat message structure
typedef struct chat_message {
    int sender_id;
    char message[256];
} chat_message;

// Create a socket
int create_socket() {
    int socket_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (socket_fd == -1) {
        perror("socket");
        exit(1);
    }
    return socket_fd;
}

// Bind the socket to a port
void bind_socket(int socket_fd, int port) {
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(port);

    if (bind(socket_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("bind");
        exit(1);
    }
}

// Listen for incoming connections
void listen_for_connections(int socket_fd) {
    if (listen(socket_fd, 5) == -1) {
        perror("listen");
        exit(1);
    }
}

// Accept an incoming connection
int accept_connection(int socket_fd) {
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);

    int client_socket_fd = accept(socket_fd, (struct sockaddr *)&client_addr, &client_addr_len);
    if (client_socket_fd == -1) {
        perror("accept");
        exit(1);
    }
    return client_socket_fd;
}

// Send a message to a client
void send_message(int socket_fd, chat_message *message) {
    if (send(socket_fd, message, sizeof(chat_message), 0) == -1) {
        perror("send");
        exit(1);
    }
}

// Receive a message from a client
void receive_message(int socket_fd, chat_message *message) {
    if (recv(socket_fd, message, sizeof(chat_message), 0) == -1) {
        perror("recv");
        exit(1);
    }
}

// Main function
int main() {
    // Create a socket
    int server_socket_fd = create_socket();

    // Bind the socket to a port
    bind_socket(server_socket_fd, PORT);

    // Listen for incoming connections
    listen_for_connections(server_socket_fd);

    // Accept an incoming connection
    int client_socket_fd = accept_connection(server_socket_fd);

    // Create a chat message
    chat_message message;

    // Send a message to the client
    strcpy(message.message, "Hello from the server!");
    message.sender_id = 1;
    send_message(client_socket_fd, &message);

    // Receive a message from the client
    receive_message(client_socket_fd, &message);
    printf("Received message from the client: %s\n", message.message);

    // Close the client socket
    close(client_socket_fd);

    // Close the server socket
    close(server_socket_fd);

    return 0;
}